<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Relevé Mensuel - <?php echo e($month); ?></title>
    <style>
        body {  font-family: "Inter var", sans-serif; margin: 0px; font-size: 0.875rem; font-weight: 400; line-height: 1.5; color: #59626f; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .summary-table { margin-bottom: 20px; }
    </style>
</head>
<body>
    <h1>Relevé Mensuel - <?php echo e($month); ?></h1>
    <p><strong style="text-transform: uppercase;"> <?php echo e($teacher->first_name); ?> <?php echo e($teacher->last_name); ?> </strong></p>

    <!-- Summary Table -->
    <table class="summary-table">
        <tr>
            <th>Nombre de Leçons</th>
            <td><?php echo e($earnings->total_lessons); ?></td>
        </tr>
        <tr>
            <th>Gains Bruts</th>
            <td><?php echo e(number_format($earnings->gross_earnings, 0, ',', ' ')); ?> XAF</td>
        </tr>
        <tr>
            <th>Déductions</th>
            <td><?php echo e(number_format(abs($earnings->deductions), 0, ',', ' ')); ?> XAF</td>
        </tr>
        <tr>
            <th>Gains Nets</th>
            <td><?php echo e(number_format($earnings->net_earnings, 0, ',', ' ')); ?> XAF</td>
        </tr>
    </table>

    <!-- Lessons Table -->
    <h2>Détails des Leçons</h2>
    <table>
        <thead>
            <tr>
                <th>Nom de l'Étudiant</th>
                <th>Activité</th>
                <th>Matière</th>
                <th>Date et Heure</th>
                <th>Montant</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $lessons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lesson): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($lesson->student->first_name); ?> <?php echo e($lesson->student->last_name); ?></td>
                    <td>Tutorat en ligne</td> <!-- Assuming all lessons are online tutoring -->
                    <td><?php echo e($lesson->course->course_title); ?></td>
                    <td><?php echo e(\Carbon\Carbon::createFromFormat('Y-m-d H:i:s', "{$lesson->date} {$lesson->time}")->setTimezone($teacher->user->timezone)->format('d/m, H:i')); ?></td>
                    <td><?php echo e(number_format($lesson->status == 'completed' ? 4000 : -4500, 0, ',', ' ')); ?> XAF</td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <p>Date d'émission: <?php echo e(now()->format('d/m/Y')); ?></p>
</body>
</html>
<?php /**PATH C:\Users\chijo\OneDrive\Desktop\Mayem Solution\Allotutor\code\backend-allotutor\resources\views/receipts/monthly.blade.php ENDPATH**/ ?>