<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Relevé de Cours</title>
    <style>
        body { font-family: Arial, sans-serif; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .summary-table { margin-bottom: 20px; }
    </style>
</head>
<body>
    <h1>Relevé de Cours</h1>
    <p>Enseignant: <?php echo e($teacher->first_name); ?> <?php echo e($teacher->last_name); ?></p>

    <!-- Lesson Details Table -->
    <table class="summary-table">
        <tr>
            <th>Nom de l'Étudiant</th>
            <td><?php echo e($student->first_name); ?> <?php echo e($student->last_name); ?></td>
        </tr>
        <tr>
            <th>Matière</th>
            <td><?php echo e($lesson->course->course_title); ?></td>
        </tr>
        <tr>
            <th>Date et Heure</th>
            <td><?php echo e(\Carbon\Carbon::createFromFormat('Y-m-d H:i:s', "{$lesson->date} {$lesson->time}")->setTimezone($teacher->user->timezone)->format('d/m/y, H:i')); ?></td>
        </tr>
        <tr>
            <th>Montant</th>
            <td><?php echo e(number_format($amount, 0, ',', ' ')); ?> XAF</td>
        </tr>
        <tr>
            <th>Status de la Transaction</th>
            <td><?php echo e($lesson->teacher_present == 'completed' ? 'Complété' : 'Absent'); ?></td>
        </tr>
    </table>

    <p>Date d'émission: <?php echo e(now()->format('d/m/Y')); ?></p>
</body>
</html>
<?php /**PATH C:\Users\chijo\OneDrive\Desktop\Mayem Solution\Allotutor\code\backend-allotutor\resources\views/receipts/single_lesson.blade.php ENDPATH**/ ?>