<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Reçu de Paiement - Enseignant</title>
    <style>
        body { font-family: "Inter var", sans-serif; margin: 0px; font-size: 0.875rem; font-weight: 400; line-height: 1.5; color: #59626f; }
        .header { text-align: center; margin-bottom: 20px; }
        .company, .teacher { margin-bottom: 30px; }
        .company { text-align: left; }
        .teacher { text-align: right; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px;}
        th, td { border: 1px solid #ddd; padding: 10px; text-align: left; }
        th { background-color: #f2f2f2; }
        .payment-details { margin-top: 30px; }
    </style>
</head>
<body>
    <!-- Header Section -->
    <div class="header">
        <h1>Reçu de Paiement</h1>
    </div>

    <!-- Company Info -->
    <div class="company">
        <div style="margin-bottom: 8px">Paiement effectué par :</div>
        <strong><?php echo e($company_name); ?></strong><br>
        <?php echo e($company_email); ?><br>
        <a href="<?php echo e($company_website); ?>" target="_blank"><?php echo e($company_website); ?></a><br><br>
    </div>

    <!-- Teacher Info -->
    <div class="teacher">
        <div style="margin-bottom: 8px">Récepteur : </div>
        <strong style="text-transform: uppercase;"><?php echo e($teacher->first_name); ?> <?php echo e($teacher->last_name); ?></strong><br>
        <?php echo e($teacher->email); ?><br>
    </div>

    <!-- Payment Summary Table -->
    <table>
        <thead>
            <tr>
                <th>Période couverte</th>
                <th>Montant Payé</th>
                <th>Date de Paiement</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>
                    <?php if($payment_start_date === 'From your first lesson made'): ?>
                        <?php echo e($payment_start_date); ?> - <?php echo e($payment_end_date); ?>

                    <?php elseif($payment_start_date !== 'No previous payment'): ?>
                        <?php echo e($payment_start_date); ?> - <?php echo e($payment_end_date); ?>

                    <?php else: ?>
                        <?php echo e($payment_start_date); ?>

                    <?php endif; ?>
                </td>
                <td><?php echo e(number_format($payment->amount, 0, ',', ' ')); ?> XAF</td>
                <td><?php echo e(\Carbon\Carbon::parse($payment->payment_date)->format('d/m/Y')); ?></td>
            </tr>
        </tbody>
    </table>

    <!-- Payment Method Info -->
    <div class="payment-details">
        <?php if($payment->payment_method === 'bank payment'): ?>
            <strong>Méthode de Paiement :</strong> Paiement bancaire<br>
            <strong>Nom du Compte :</strong> <?php echo e($payment->account_name); ?><br>
            <strong>IBAN :</strong> <?php echo e($payment->account_iban); ?><br>
            <strong>BIC :</strong> <?php echo e($payment->account_bic); ?><br>
        <?php elseif($payment->payment_method === 'mobile payment'): ?>
            <strong>Méthode de Paiement :</strong> Paiement mobile<br>
            <strong>Numéro de Mobile :</strong> <?php echo e($payment->mobile_number); ?><br>
            <strong>Opérateur Mobile :</strong> <?php echo e($payment->mobile_operator); ?><br>
        <?php elseif($payment->payment_method === 'cash payment'): ?>
            <strong>Méthode de Paiement :</strong> Espèces<br>
        <?php elseif($payment->payment_method === 'cheque payment'): ?>
            <strong>Méthode de Paiement  :</strong> Chèque<br>
        <?php elseif($payment->payment_method === 'bank transfer'): ?>
            <strong>Méthode de Paiement :</strong> Virement bancaire<br>
            <strong>Nom du Compte :</strong> <?php echo e($payment->account_name); ?><br>
            <strong>IBAN :</strong> <?php echo e($payment->account_iban); ?><br>
            <strong>BIC :</strong> <?php echo e($payment->account_bic); ?><br>
        <?php endif; ?>
    </div>

    <!-- Footer -->
    <p>Date d'émission : <?php echo e(now()->format('d/m/Y')); ?></p>
</body>
</html>
<?php /**PATH C:\Users\chijo\OneDrive\Desktop\Mayem Solution\Allotutor\code\backend-allotutor\resources\views/receipts/payment.blade.php ENDPATH**/ ?>