<?php

use App\Models\User;
use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;
use PhpParser\Node\Stmt\TryCatch;
use Stripe\Stripe;
use Stripe\StripeClient;

/*
|--------------------------------------------------------------------------
| Console Routes
|--------------------------------------------------------------------------
|
| This file is where you may define all of your Closure based console
| commands. Each Closure is bound to a command instance allowing a
| simple approach to interacting with each command's IO methods.
|
*/

Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote');

Artisan::command('paymentMethod', function(){
    $user = User::all();
    $stripe = new StripeClient(env('STRIPE_SECRET'));

    $user->map(function(User $user) use($stripe) {
        try {
            $stripe_id = $user->stripe_id;
            if($stripe_id){
                $resposne = $stripe->customers->allPaymentMethods($stripe_id);
                dump($resposne);
            }
        } catch (\Exception $e) {
            $this->error("FAILED");
            $this->line($e->getMessage());
            $this->newLine(2);
        }
    });
});
