<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\FaqController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\CourseController;
use App\Http\Controllers\GoogleController;
use App\Http\Controllers\LessonController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\MeetingController;
use App\Http\Controllers\MessageController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\RevenueController;
use App\Http\Controllers\StudentController;
use App\Http\Controllers\TeacherController;
use App\Http\Controllers\WebhookController;
use App\Http\Controllers\GoogleDriveController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\AcademiclevelController;
use App\Http\Controllers\PaymentMethodController;
use App\Http\Controllers\CourseCategoryController;
use App\Http\Controllers\TeacherPaymentController;
use App\Http\Controllers\SubscriptionPlanController;
use App\Http\Controllers\AcademicLevelClassController;
use App\Http\Controllers\AccountPauseHistoryController;
use App\Http\Controllers\StoreTeacherPaymentController;
use App\Http\Controllers\TeacherAvailabilityController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// User Routes
Route::group(['prefix' => '/users'], function () {
    Route::post('/registration', [UserController::class, 'register']);
    Route::post('/login', [UserController::class, 'login']);
    Route::post('/request_restore', [UserController::class, 'requestRestore']);
    Route::post('/restore', [UserController::class, 'restore']);
    Route::post('/forgot_password', [UserController::class, 'sendPasswordResetLink'])->name('password.email');
    Route::post('/reset_password', [UserController::class, 'resetPassword'])->name('password.reset');
    Route::group(['middleware' => ['auth:sanctum']], function () {
        Route::post('/logout', [UserController::class, 'logout']);
        Route::post('/logout_allDevice', [UserController::class, 'logoutFromAllDevices']);
        Route::get('/newUsers', [UserController::class, 'newUsers']);
        Route::get('/studentsTeachers_list', [UserController::class, 'getStudentsTeachersList']);
        Route::get('/{user}', [UserController::class, 'show']);
        Route::post('/pusher/auth', [UserController::class, 'authenticate']);
        Route::get('/{user}/getSecret', [UserController::class, 'getSecret']);
        Route::get('/{user}/getTimezone', [UserController::class, 'getTimezone']);
        Route::put('/{user}/update_password', [UserController::class, 'updatePassword']);
        Route::post('/{user}/verify_identity', [UserController::class, 'verifyIdentity']);
        Route::post('/{user}/initiate_email_update', [UserController::class, 'initiateEmailUpdate']);
        Route::post('/{user}/confirm_email_update', [UserController::class, 'confirmEmailUpdate']);
        Route::put('/{user}/update_timezone', [UserController::class, 'updateTimezone']);
        Route::post('/{user}/add_card', [UserController::class, 'attachCardToCustomer']);
        Route::post('/{user}/add_stripeCustomer', [UserController::class, 'createStripeCustomerAccount']);
        Route::post('/{user}/add_stripeConnectAccount', [UserController::class, 'createStripeConnectAccount']);
        Route::post('/{user}/add_bankDetail', [UserController::class, 'addBankDetail']);
        Route::get('/{user}/get_paymentMethods', [UserController::class, 'getPaymentmethods']);
        Route::get('/{user}/get_bankDetail', [UserController::class, 'getBankDetail']);
        Route::put('/{user}/set_defaultPaymentMethod', [UserController::class, 'updateDefaultPaymentMethod']);
        Route::get('/{user}/discussion_list', [UserController::class, 'getDiscussionList']);
        Route::get('/{user}/discussions/{otherUser}', [UserController::class, 'getDiscussion']);
        Route::delete('/{user}/discussions/{otherUser}/delete', [UserController::class, 'deleteDiscussion']);
        Route::get('/{user}/contact', [UserController::class, 'getContact']);
        Route::put('/{user}/discussions/{otherUser}/mark-all-as-read', [UserController::class, 'markDiscussionMessagesAsRead']);
        Route::post('/{user}/deactivate', [AccountPauseHistoryController::class, 'deactivate']);
        Route::post('/{user}/activate', [AccountPauseHistoryController::class, 'activate']);
        Route::put('/{user}/update_notificationPref', [UserController::class, 'updateNotificationPreferences']);
        Route::put('/{user}/reset_notificationDefaultPref', [UserController::class, 'resetNotificationPreferences']);
        Route::post('/{id}/delete', [UserController::class, 'destroy']);
        Route::group(['middleware' => ['auth:sanctum'], 'prefix' => '/{user}/notifications'], function () {
            Route::get('/', [NotificationController::class, 'index']);
            Route::get('/unSeen', [NotificationController::class, 'getUnseenCount']);
            Route::get('/{notification}', [NotificationController::class, 'show']);
            Route::post('/{notification}/read', [NotificationController::class, 'markAsRead']);
            Route::post('/read_all', [NotificationController::class, 'markAllAsRead']);
            Route::post('/{notification}/seen', [NotificationController::class, 'markAsSeen']);
            Route::post('/seen_all', [NotificationController::class, 'markAllAsSeen']);
            Route::delete('/{notification}', [NotificationController::class, 'destroy']);
        });
        Route::group(['middleware' => ['role:admin']], function () {
            Route::get('/', [UserController::class, 'index']);
            Route::delete('/{user}/permanent_delete', [UserController::class, 'PermanentDelete']);
        });
    });
});

Route::group(['prefix' => '/course_categories'], function () {
    Route::get('/', [CourseCategoryController::class, 'index']);
    Route::get('/{category}', [CourseCategoryController::class, 'show']);
    Route::group(['middleware' => ['auth:sanctum', 'role:admin']], function () {
        Route::post('/create', [CourseCategoryController::class, 'store']);
        Route::put('/{category}/update', [CourseCategoryController::class, 'update']);
        Route::delete('/{category}/delete', [CourseCategoryController::class, 'destroy']);
    });
});

// academic_levels Routes
Route::group(['prefix' => '/academic_levels'], function () {
    Route::get('/', [AcademiclevelController::class, 'index']);
    Route::get('/{level}', [AcademiclevelController::class, 'show']);
    Route::group(['middleware' => ['auth:sanctum', 'role:admin']], function () {
        Route::post('/create', [AcademiclevelController::class, 'store']);
        Route::put('/{level}/update', [AcademiclevelController::class, 'update']);
        Route::delete('/{level}/delete', [AcademiclevelController::class, 'destroy']);
    });
});

// student_levels Routes
Route::group(['prefix' => '/academic_level_classes'], function () {
    Route::get('/', [AcademicLevelClassController::class, 'index']);
    Route::get('/{class}', [AcademicLevelClassController::class, 'show']);
    Route::group(['middleware' => ['auth:sanctum', 'role:admin']], function () {
        Route::post('/create', [AcademicLevelClassController::class, 'store']);
        Route::put('/{class}/update', [AcademicLevelClassController::class, 'update']);
        Route::delete('/{class}/delete', [AcademicLevelClassController::class, 'destroy']);
    });
});

// Course Routes
Route::group(['prefix' => '/courses'], function () {
    Route::get('/', [CourseController::class, 'index']);
    Route::get('/showStudents', [CourseController::class, 'showStudents']);
    Route::get('/showTeachers', [CourseController::class, 'showTeachers']);
    Route::get('/{course}', [CourseController::class, 'show']);
    Route::group(['middleware' => ['auth:sanctum', 'role:admin']], function () {
        Route::get('/{course}/teacher_student', [CourseController::class, 'showTeacherStudent']);
        Route::post('/{course}/linkUsers', [CourseController::class, 'courseUserLink']);
        Route::post('/{course}/unlinkUsers', [CourseController::class, 'courseUserUnlink']);
        Route::post('/create', [CourseController::class, 'store']);
        Route::put('/{course}/update', [CourseController::class, 'update']);
        Route::put('/{course}/statusUpdate', [CourseController::class, 'statusUpdate']);
        Route::delete('/{course}/delete', [CourseController::class, 'destroy']);
    });
});
// SubscriptionPlan Routes
Route::group(['prefix' => '/subscriptionPlans'], function () {
    Route::get('/', [SubscriptionPlanController::class, 'index']);
    Route::get('/{subscriptionPlan}', [SubscriptionPlanController::class, 'show']);
    Route::group(['middleware' => ['auth:sanctum', 'role:admin']], function () {
        Route::post('/create', [SubscriptionPlanController::class, 'store']);
        Route::put('/{subscriptionPlan}/update', [SubscriptionPlanController::class, 'update']);
        Route::get('/{subscriptionPlan}/subscriptions', [SubscriptionPlanController::class, 'showSubscriptions']);
        Route::put('/{subscriptionPlan}/statusUpdate', [SubscriptionPlanController::class, 'statusUpdate']);
        Route::delete('/{subscriptionPlan}/delete', [SubscriptionPlanController::class, 'destroy']);
    });
});

// Teacher Routes
Route::group(['prefix' => '/teachers'], function () {
    Route::get('/getTeacherFilterList', [TeacherController::class, 'filterTeachers']);
    Route::get('/{teacher}/detach');
    Route::group(['middleware' => ['auth:sanctum']], function () {
        Route::get('/{teacher}', [TeacherController::class, 'show'])->where('teacher', '[0-9]+');
        Route::get('/{teacher}/lessons', [TeacherController::class, 'showLessons']);
        Route::post('/{teacher}/update', [TeacherController::class, 'update']);
        Route::get('/{teacher}/revenue_detail', [TeacherPaymentController::class, 'getTeachetRevenueData']);
        Route::get('/{teacher}/monthly_earnings', [TeacherPaymentController::class, 'getMonthlyEarnings']);
        Route::get('/{teacher}/receipt/{month}', [TeacherPaymentController::class, 'downloadReceipt']);
        Route::get('/{teacher}/receipt/payments/{payment}', [TeacherPaymentController::class, 'downloadTeacherPaymentReceipt']);
        Route::get('/{teacher}/students', [TeacherController::class, 'showStudents']);
        Route::get('/{teacher}/students/{student}', [TeacherController::class, 'showStudent']);
        Route::get('/{teacher}/students/{student}/lessons', [TeacherController::class, 'getLessonsByTeacherAndStudent']);
        Route::get('/{teacher}/students/{student}/statistics', [TeacherController::class, 'getTeacherStudentStatistics']);
        Route::post('/{teacher}/courses/addCourse', [TeacherController::class, 'teacherCourseLink']);
        Route::post('/{teacher}/courses/removeCourse', [TeacherController::class, 'teacherCourseUnlink']);
        Route::get('/{teacher}/courses', [TeacherController::class, 'showCourses']);
        Route::get('/{teacher}/studentCourseLink', [TeacherController::class, 'showCourseStudents']);
        Route::get('/{teacher}/statistics', [TeacherController::class, 'teacherStatistics']);
        Route::get('/{teacher}/teacher_new_student_statistics', [TeacherController::class, 'teacherNewStudentStatistics']);
        Route::post('/{teacher}/teacherStatusUpdate', [TeacherController::class, 'teacherStatusUpdate']);
        Route::post('/{teacher}/saveAvailability', [TeacherAvailabilityController::class, 'store']);
        Route::get('/{teacher}/availabilities', [TeacherAvailabilityController::class, 'index']);
        Route::put('/{teacher}/availabilities/{availability}/edit', [TeacherAvailabilityController::class, 'update']);
        Route::delete('/{teacher}/availabilities/{availability}/delete', [TeacherAvailabilityController::class, 'destroy']);
        Route::group(['middleware' => ['role:admin']], function () {
            Route::post('/create', [TeacherController::class, 'store']);
            Route::post('/{teacher}/statusUpdate', [TeacherController::class, 'statusUpdate']);
            Route::get('/', [TeacherController::class, 'index']);
            Route::get('/balances', [TeacherController::class, 'getBalance']);
            Route::delete('/{teacher}/delete', [TeacherController::class, 'destroy']);
        });
    });

});

// Student Routes
Route::group(['prefix' => '/students'], function () {
    Route::post('/create', [StudentController::class, 'store']);
    Route::get('/{student}', [StudentController::class, 'show']);
    Route::group(['middleware' => ['auth:sanctum']], function () {
        Route::group(['middleware' => ['check.student.authorization']], function () {
            Route::get('/{student}/lessons', [StudentController::class, 'showLessons']);
            Route::get('/{student}/courses', [StudentController::class, 'showCourses']);
            Route::get('/{student}/credits', [StudentController::class, 'getCredits']);
            Route::get('/{student}/current_subscription', [StudentController::class, 'getCurrentSubscription']);
            Route::get('/{student}/subscription_list', [StudentController::class, 'getStudentSubscriptions']);
            Route::get('/{student}/pendingSubscriptionsProcessing', [StudentController::class, 'processPendingSubscriptionsForStudent']);
            Route::get('/{student}/checkFreeLesson', [StudentController::class, 'checkFreeLesson']);
            Route::post('/{student}/courses/addCourse', [StudentController::class, 'studentLinkCourse']);
            Route::get('/{student}/teacherCourseLink', [StudentController::class, 'showCourseTeachers']);
            Route::post('/{student}/courses/removeCourse', [StudentController::class, 'studentCourseUnlink']);
            Route::get('/{student}/teachers', [StudentController::class, 'showTeachers']);
            Route::post('/{student}/update', [StudentController::class, 'update']);
            Route::get('/{student}/statistics', [StudentController::class, 'studentStatistics']);
        });
        Route::group(['middleware' => ['role:admin']], function () {
            Route::post('/{student}/statusUpdate', [StudentController::class, 'statusUpdate']);
            Route::get('/', [StudentController::class, 'index']);
            Route::delete('/{student}/delete', [StudentController::class, 'destroy']);
        });
    });
});

// Admin Routes
Route::group(['prefix' => '/admins'], function () {
    Route::group(['middleware' => ['auth:sanctum']], function () {
        Route::group(['middleware' => ['role:admin']], function () {
            Route::get('/specific_app_statistics', [AdminController::class, 'getnSpecificAppStatistics']);
            Route::get('/revenue_statistics', [RevenueController::class, 'index']);
            Route::group(['prefix' => '/teacher_payments'], function () {
                Route::get('/', [TeacherPaymentController::class, 'index']);
                Route::post('/store', [TeacherPaymentController::class, 'store']);
                Route::get('/{payment}', [TeacherPaymentController::class, 'show']);
                Route::put('/{payment}/update', [TeacherPaymentController::class, 'update']);
                Route::delete('/{payment}/delete', [TeacherPaymentController::class, 'destroy']);
                Route::put('/{payment}/statusUpdate', [TeacherPaymentController::class, 'statusUpdate']);
            });
        });
    });
});

// Lessons Routes
Route::group(['prefix' => '/lessons'], function () {
    Route::group(['middleware' => ['auth:sanctum']], function () {
        // Admin-specific routes FIRST
        Route::group(['middleware' => ['role:admin']], function () {
            Route::get('/', [LessonController::class, 'index']);
            Route::get('/trials', [LessonController::class, 'trialLessonList']);
            Route::delete('/{lesson}/reject', [LessonController::class, 'rejectTrial']);
            Route::put('/{lesson}/finalised_trial', [LessonController::class, 'finalisedTrialLesson']);
            Route::delete('/{lesson}/delete', [LessonController::class, 'destroy']);
        });

        // Common routes
        Route::post('/create', [LessonController::class, 'store']);
        Route::get('/getAvailabilities', [LessonController::class, 'getAvailabilities']);
        Route::post('/createTrialLesson', [LessonController::class, 'storeTrialLesson']);
        
        // Parameterized routes LAST
        Route::group(['middleware' => ['lesson.access']], function () {
            Route::get('/{lesson}', [LessonController::class, 'show']);
            Route::put('/{lesson}/update', [LessonController::class, 'update']);
            Route::get('/{lesson}/status', [LessonController::class, 'getStatus']);
            Route::put('/{lesson}/reprogramLesson', [LessonController::class, 'reprogramLesson']);
            Route::put('/{lesson}/statusUpdate', [LessonController::class, 'statusUpdate']);
        });
    });
});

// Meetings Routes
Route::group(['prefix' => '/meetings'], function () {
    Route::group(['middleware' => ['auth:sanctum']], function () {
        Route::post('/create', [MeetingController::class, 'createMeeting']);
        Route::get('/{meeting}', [MeetingController::class, 'show']);
        Route::get('/participant-join/{meeting}', [MeetingController::class, 'participantJoin']);
        Route::get('/participant-leave/{meeting}', [MeetingController::class, 'participantLeave']);
        Route::get('/end-meeting/{meeting}', [MeetingController::class, 'endMeeting']);
        Route::group(['middleware' => ['role:admin']], function () {
            Route::get('/', [MeetingController::class, 'index']);
            Route::delete('/{meeting}/delete', [MeetingController::class, 'destroy']);
        });
    });
});

// Subscription Routes
Route::group(['prefix' => '/subscriptions'], function () {
    Route::group(['middleware' => ['auth:sanctum']], function () {
        Route::post('/create', [SubscriptionController::class, 'store']);
        Route::put('/{subscription}/update', [SubscriptionController::class, 'update']);
        Route::post('/{subscription}/completed', [SubscriptionController::class, 'completed']);
        Route::post('/{subscription}/savePaymentMethod', [SubscriptionController::class, 'SavePaymentMethodAfterSubscription']);
        Route::post('/{subscription}/failed', [SubscriptionController::class, 'failed']);
        Route::get('/{subscription}/receipt', [SubscriptionController::class, 'subscriptionReceipt']);
        Route::delete('/{subscription}/delete', [SubscriptionController::class, 'destroy']);
        Route::group(['middleware' => ['role:admin']], function () {
            Route::get('/', [SubscriptionController::class, 'index']);
            Route::get('/{subscription}', [SubscriptionController::class, 'show']);
            Route::post('/create_no_payment_subscription', [SubscriptionController::class, 'subscriptionWithOutPayment']);
            Route::put('/{subscription}/statusUpdate', [SubscriptionController::class, 'statusUpdate']);
            Route::put('/{subscription}/cancel', [SubscriptionController::class, 'cancel']);
        });
    });
});

// Payment Routes
Route::group(['prefix' => '/payments'], function () {
    Route::group(['middleware' => ['auth:sanctum']], function () {
        Route::post('/createSecret', [PaymentController::class, 'createSecret']);
        Route::post('/saveCard_payment', [PaymentController::class, 'SaveCardPayment']);
        Route::post('/transfer_funds', [PaymentController::class, 'transferFunds']);
    });
});

// Massage Routes
Route::group(['prefix' => '/messages'], function () {
    Route::group(['middleware' => ['auth:sanctum']], function () {
        Route::post('/send', [MessageController::class, 'sendMessage']);
        Route::put('/{message}/mark-as-read', [MessageController::class, 'markMessageAsRead']);
    });
});

// Massage Routes
Route::group(['prefix' => '/reports'], function () {
    Route::group(['middleware' => ['auth:sanctum']], function () {
        Route::get('/', [ReportController::class, 'index']);
        Route::post('/send', [ReportController::class, 'store']);
        Route::get('/{report}', [ReportController::class, 'show']);
        Route::group(['middleware' => ['role:admin']], function () {
            Route::put('/{report}/statusUpdate', [ReportController::class, 'statusUpdate']);
            Route::put('/{report}/edit', [ReportController::class, 'update']);
            Route::delete('/{report}/delete', [ReportController::class, 'destroy']);
        });
    });
});

// paymentMethod Routes
Route::group(['prefix' => '/paymentMethods'], function () {
    Route::group(['middleware' => ['auth:sanctum']], function () {
        Route::post('/create', [PaymentMethodController::class, 'store']);
        Route::post('/detachPaymentMethod', [PaymentMethodController::class, 'detachedPmFromStripe']);
        Route::delete('/{paymentMethod}/delete', [PaymentMethodController::class, 'destroy']);
    });
});

// FAQ Routes
Route::group(['prefix' => '/faqs'], function () {
    Route::get('/', [FaqController::class, 'index']); // Publicly accessible
    Route::group(['middleware' => ['auth:sanctum', 'role:admin']], function () {
        Route::post('/create', [FaqController::class, 'store']);
        Route::get('/{faq}', [FaqController::class, 'show']);
        Route::put('/{faq}/update', [FaqController::class, 'update']);
        Route::delete('/{faq}/delete', [FaqController::class, 'destroy']);
    });
});

// webhook routes
Route::post('/webhook/stripe', [WebhookController::class, 'handleStripeWebhook']);

// Google Routes
Route::prefix('/drive')->middleware(['auth:sanctum'])->group(function () {
    Route::get('/files', [GoogleDriveController::class, 'index']);
    Route::get('/folders', [GoogleDriveController::class, 'getAllFolders']);
    Route::post('/folders/create', [GoogleDriveController::class, 'createFolder']);
    Route::post('/files/upload', [GoogleDriveController::class, 'uploadFiles']);
    Route::put('/files/{fileId}/rename', [GoogleDriveController::class, 'renameFile']);
    Route::put('/files/{fileId}/move', [GoogleDriveController::class, 'moveFile']);
    Route::delete('/files/{fileId}/delete', [GoogleDriveController::class, 'destroy']);
    Route::get('/files/{fileId}', [GoogleDriveController::class, 'getFileDetails']);
});

