<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Reçu de Paiement - Abonnement</title>
    <style>
        body {  font-family: "Inter var", sans-serif; margin: 0px; font-size: 0.875rem; font-weight: 400; line-height: 1.5; color: #59626f; }
        .header { text-align: center; margin-bottom: 20px; }
        .company { text-align: left; margin-bottom: 30px; } /* Set the alignment to the right and add some spacing */
        .student { text-align: right; margin-bottom: 30px; } /* Set the alignment to the right and add some spacing */
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ddd; padding: 10px; text-align: left; }
        th { background-color: #f2f2f2; }
    </style>
</head>
<body>
    <!-- Header Section -->
    <div class="header">
        <h1>Reçu de Paiement</h1>
    </div>

    <!-- Company Info -->
    <div class="company">
        <strong>{{ $company_name }}</strong><br>
        Email : {{ $company_email }}<br>
        Site Web : <a href="{{ $company_website }}" target="_blank">{{ $company_website }}</a><br><br>
    </div>

    <!-- Student Info (placed a few centimeters below company info) -->
    <div class="student" style="margin-top: 50px;"> <!-- Additional spacing added here -->
        <strong>Étudiant :</strong> {{ $student_name }}<br>
        Email : {{ $student_email }}<br>
    </div>

    <!-- Payment Details Table -->
    <table>
        <thead>
            <tr>
                <th>Date de Paiement</th>
                <th>Service Payé</th>
                <th>Période de Validité</th>
                <th>Méthode de Paiement</th>
                <th>Montant Payé</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>{{ $payment_date }}</td>
                <td>{{ $subscription_plan_name }}</td>
                <td>{{ $subscription_start_date }} - {{ $subscription_end_date }}</td>
                <td>{{ $payment_method }}</td>
                <td>{{ $subscription_amount }}</td>
            </tr>
        </tbody>
    </table>

    <!-- Footer -->
    <p>Date d'émission : {{ now()->format('d/m/Y') }}</p>
</body>
</html>
