<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Reçu de Paiement - Enseignant</title>
    <style>
        body { font-family: "Inter var", sans-serif; margin: 0px; font-size: 0.875rem; font-weight: 400; line-height: 1.5; color: #59626f; }
        .header { text-align: center; margin-bottom: 20px; }
        .company, .teacher { margin-bottom: 30px; }
        .company { text-align: left; }
        .teacher { text-align: right; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px;}
        th, td { border: 1px solid #ddd; padding: 10px; text-align: left; }
        th { background-color: #f2f2f2; }
        .payment-details { margin-top: 30px; }
    </style>
</head>
<body>
    <!-- Header Section -->
    <div class="header">
        <h1>Reçu de Paiement</h1>
    </div>

    <!-- Company Info -->
    <div class="company">
        <div style="margin-bottom: 8px">Paiement effectué par :</div>
        <strong>{{ $company_name }}</strong><br>
        {{ $company_email }}<br>
        <a href="{{ $company_website }}" target="_blank">{{ $company_website }}</a><br><br>
    </div>

    <!-- Teacher Info -->
    <div class="teacher">
        <div style="margin-bottom: 8px">Récepteur : </div>
        <strong style="text-transform: uppercase;">{{ $teacher->first_name }} {{ $teacher->last_name }}</strong><br>
        {{ $teacher->email }}<br>
    </div>

    <!-- Payment Summary Table -->
    <table>
        <thead>
            <tr>
                <th>Période couverte</th>
                <th>Montant Payé</th>
                <th>Date de Paiement</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>
                    @if($payment_start_date === 'From your first lesson made')
                        {{ $payment_start_date }} - {{ $payment_end_date }}
                    @elseif($payment_start_date !== 'No previous payment')
                        {{ $payment_start_date }} - {{ $payment_end_date }}
                    @else
                        {{ $payment_start_date }}
                    @endif
                </td>
                <td>{{ number_format($payment->amount, 0, ',', ' ') }} XAF</td>
                <td>{{ \Carbon\Carbon::parse($payment->payment_date)->format('d/m/Y')  }}</td>
            </tr>
        </tbody>
    </table>

    <!-- Payment Method Info -->
    <div class="payment-details">
        @if($payment->payment_method === 'bank payment')
            <strong>Méthode de Paiement :</strong> Paiement bancaire<br>
            <strong>Nom du Compte :</strong> {{ $payment->account_name }}<br>
            <strong>IBAN :</strong> {{ $payment->account_iban }}<br>
            <strong>BIC :</strong> {{ $payment->account_bic }}<br>
        @elseif($payment->payment_method === 'mobile payment')
            <strong>Méthode de Paiement :</strong> Paiement mobile<br>
            <strong>Numéro de Mobile :</strong> {{ $payment->mobile_number }}<br>
            <strong>Opérateur Mobile :</strong> {{ $payment->mobile_operator }}<br>
        @elseif($payment->payment_method === 'cash payment')
            <strong>Méthode de Paiement :</strong> Espèces<br>
        @elseif($payment->payment_method === 'cheque payment')
            <strong>Méthode de Paiement  :</strong> Chèque<br>
        @elseif($payment->payment_method === 'bank transfer')
            <strong>Méthode de Paiement :</strong> Virement bancaire<br>
            <strong>Nom du Compte :</strong> {{ $payment->account_name }}<br>
            <strong>IBAN :</strong> {{ $payment->account_iban }}<br>
            <strong>BIC :</strong> {{ $payment->account_bic }}<br>
        @endif
    </div>

    <!-- Footer -->
    <p>Date d'émission : {{ now()->format('d/m/Y') }}</p>
</body>
</html>
