<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Relevé Mensuel - {{ $month }}</title>
    <style>
        body {  font-family: "Inter var", sans-serif; margin: 0px; font-size: 0.875rem; font-weight: 400; line-height: 1.5; color: #59626f; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .summary-table { margin-bottom: 20px; }
    </style>
</head>
<body>
    <h1>Relevé Mensuel - {{ $month }}</h1>
    <p><strong style="text-transform: uppercase;"> {{ $teacher->first_name }} {{ $teacher->last_name }} </strong></p>

    <!-- Summary Table -->
    <table class="summary-table">
        <tr>
            <th>Nombre de Leçons</th>
            <td>{{ $earnings->total_lessons }}</td>
        </tr>
        <tr>
            <th>Gains Bruts</th>
            <td>{{ number_format($earnings->gross_earnings, 0, ',', ' ') }} XAF</td>
        </tr>
        <tr>
            <th>Déductions</th>
            <td>{{ number_format(abs($earnings->deductions), 0, ',', ' ') }} XAF</td>
        </tr>
        <tr>
            <th>Gains Nets</th>
            <td>{{ number_format($earnings->net_earnings, 0, ',', ' ') }} XAF</td>
        </tr>
    </table>

    <!-- Lessons Table -->
    <h2>Détails des Leçons</h2>
    <table>
        <thead>
            <tr>
                <th>Nom de l'Étudiant</th>
                <th>Activité</th>
                <th>Matière</th>
                <th>Date et Heure</th>
                <th>Montant</th>
            </tr>
        </thead>
        <tbody>
            @foreach($lessons as $lesson)
                <tr>
                    <td>{{ $lesson->student->first_name }} {{ $lesson->student->last_name }}</td>
                    <td>Tutorat en ligne</td> <!-- Assuming all lessons are online tutoring -->
                    <td>{{ $lesson->course->course_title }}</td>
                    <td>{{  \Carbon\Carbon::createFromFormat('Y-m-d H:i:s', "{$lesson->date} {$lesson->time}")->setTimezone($teacher->user->timezone)->format('d/m, H:i') }}</td>
                    <td>{{ number_format($lesson->status == 'completed' ? 4000 : -4500, 0, ',', ' ') }} XAF</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <p>Date d'émission: {{ now()->format('d/m/Y') }}</p>
</body>
</html>
