<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;

use App\Models\AcademicLevel;
use App\Models\AcademicLevelClass;
use App\Models\CourseCategory;
use App\Models\SubscriptionPlan;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        // Clear the tables before seeding
        $tables = [
           'students',
           'academic_levels',
           'academic_level_classes',
           'course_categories',
           'subscription_plans',
           'users',
           'permissions',
           'roles',
        ];

        foreach ($tables as $table) {
            DB::table($table)->truncate();
        }

        User::create([
            'email' => 'admin@example.com',
            'password' => Hash::make('password'),
        ]);

        Permission::create(['name' => 'create courses']);
        Permission::create(['name' => 'edit courses']);
        Permission::create(['name' => 'delete courses']);
        Permission::create(['name' => 'edit lessons']);

        Role::create(['name' => 'admin'])->givePermissionTo(['create courses', 'edit courses', 'delete courses']);
        Role::create(['name' => 'teacher'])->givePermissionTo(['edit lessons']);
        Role::create(['name' => 'student'])->givePermissionTo(['edit lessons']);

        // Assign roles and permissions
        $adminUser = User::where('email', 'admin@example.com')->first();
        $eleveUser = User::where('email', 'eleve@example.com')->first();
        $tuteurUser = User::where('email', 'tuteur@example.com')->first();
        $adminRole = Role::where('name', 'admin')->first();
        $eleveRole = Role::where('name', 'student')->first();
        $tuteurRole = Role::where('name', 'teacher')->first();
        $adminUser->assignRole($adminRole);
        $eleveUser->assignRole($eleveRole);
        $tuteurUser->assignRole($tuteurRole);

        CourseCategory::create(['course_category_name' => 'Sciences']);
        CourseCategory::create(['course_category_name' => 'Arts']);
        CourseCategory::create(['course_category_name' => 'Langues']);

        SubscriptionPlan::create([
            'name' => '4 Crédits',
            'credits' => 4,
            'duration_days' => 30,
            'price' => 9.99,
        ]);
        SubscriptionPlan::create([
            'name' => '8 Crédits ',
            'credits' => 8,
            'duration_days' => 45,
            'price' => 14.99,
        ]);
        SubscriptionPlan::create([
            'name' => '12 Crédits',
            'credits' => 12,
            'duration_days' => 60,
            'price' => 19.99,
        ]);
        // Create Academic Levels
        $primaryLevel = AcademicLevel::create(['level_title' => 'École Primaire']);
        $collegeLevel = AcademicLevel::create(['level_title' => 'Collège']);
        $highSchoolLevel = AcademicLevel::create(['level_title' => 'Lycée']);

        // Primary School Classes
        AcademicLevelClass::create(['class_name' => 'CP', 'academic_level_id' => $primaryLevel->id]);
        AcademicLevelClass::create(['class_name' => 'CE1', 'academic_level_id' => $primaryLevel->id]);
        AcademicLevelClass::create(['class_name' => 'CE2', 'academic_level_id' => $primaryLevel->id]);
        AcademicLevelClass::create(['class_name' => 'CM1', 'academic_level_id' => $primaryLevel->id]);
        AcademicLevelClass::create(['class_name' => 'CM2', 'academic_level_id' => $primaryLevel->id]);

        // Collège Classes
        AcademicLevelClass::create(['class_name' => 'Sixième', 'academic_level_id' => $collegeLevel->id]);
        AcademicLevelClass::create(['class_name' => 'Cinquième', 'academic_level_id' => $collegeLevel->id]);
        AcademicLevelClass::create(['class_name' => 'Quatrième', 'academic_level_id' => $collegeLevel->id]);
        AcademicLevelClass::create(['class_name' => 'Troisième', 'academic_level_id' => $collegeLevel->id]);

        // Lycée Classes
        AcademicLevelClass::create(['class_name' => 'Seconde', 'academic_level_id' => $highSchoolLevel->id]);
        AcademicLevelClass::create(['class_name' => 'Première', 'academic_level_id' => $highSchoolLevel->id]);
        AcademicLevelClass::create(['class_name' => 'Terminale', 'academic_level_id' => $highSchoolLevel->id]);
    }
}
