<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('reports', function (Blueprint $table) {
            $table->string('category')->default('null'); // Specific category within type
            $table->string('attachment_path')->nullable(); // Path for attachments
            $table->text('resolution_notes')->nullable(); // Notes for resolution
            $table->renameColumn('type', 'report_type'); // Rename column 'type' to 'report_type'
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('reports', function (Blueprint $table) {
            $table->dropColumn(['category', 'attachment_path', 'resolution_notes']);
            $table->renameColumn('report_type', 'type'); // Revert column name back to 'type'
        });
    }
};