<?php

use App\Models\Teacher;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('teacher_payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('teacher_id')->constrained()->onDelete('cascade');
            $table->double('amount');
            $table->string('description')->nullable();
            $table->enum('payment_method', ['bank payment', 'mobile payment', 'cheque payment', 'bank transfer', 'cash payment']);
            $table->string('account_iban')->nullable();
            $table->string('account_bic')->nullable();
            $table->string("account_name")->nullable();
            $table->string('mobile_number')->nullable();
            $table->string('mobile_operator')->nullable();
            $table->enum('status', ['pending', 'pay', 'canceled'])->default('pay');
            $table->timestamp('payment_date');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('teacher_payments');
    }
};
