<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('notification_preferences', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->boolean('new_lessons')->default(true);
            $table->boolean('lesson_updates')->default(true);
            $table->boolean('new_messages')->default(true);
            $table->boolean('events_promotions')->default(true);
            $table->boolean('app_updates')->default(true);
            $table->boolean('lesson_reminders')->default(true);
            $table->enum('reminder_time', ['15', '60', '180', '360'])->default('60'); // in minutes
            $table->boolean('email_notifications')->default(false);
            $table->boolean('in_app_notifications')->default(true);
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('notification_preferences');
    }
};
