<?php

use App\Models\User;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payment_methods', function (Blueprint $table) {
            $table->id();
            $table->string('stripe_payment_method_id')->unique();
            $table->string('type');
            $table->decimal('card_exp_month', 2, 0)->nullable();
            $table->decimal('card_exp_year', 8, 0)->nullable();
            $table->string('card_last4', length: 8)->nullable();
            $table->string('card_brand')->nullable();
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->foreignIdFor(User::class)->constrained();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payment_methods');
    }
};
