<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('payments', function(Blueprint $table){
            $table->dropColumn('payment_reference');
            $table->dropColumn('gateway_response');
            $table->string('payment_method')->nullable()->change();
            $table->string('stripe_payment_id')->nullable();
            $table->decimal('stripe_fees', 8, 2)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('payments', function(Blueprint $table){
            $table->dropColumn('stripe_payment_id');
            $table->dropColumn('stripe_fees'); 
            $table->string('payment_method')->change();
            $table->string('payment_reference')->nullable();
            $table->string('gateway_response')->nullable();
        });
    }
};
