<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class() extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::statement('ALTER TABLE lessons DROP CONSTRAINT lessons_status_check;');
        DB::statement("ALTER TABLE lessons ADD CONSTRAINT lessons_status_check CHECK (status IN ('scheduled','completed', 'canceled', 'expired','in_progress','paused', 'pending', 'pending_schedule'))");
        Schema::table('meetings', function (Blueprint $table) {
            $table->integer('total_duration')->default(0)->after('room_id');
            $table->timestamp('session_start_time')->nullable()->after('total_duration');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('meetings', function (Blueprint $table) {
            $table->dropColumn('total_duration');
            $table->dropColumn('session_start_time');
        });
    }
};
