<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class() extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('teachers', function (Blueprint $table) {
            // Add new "age" column of type integer
            $table->integer('age')->nullable();
            $table->string('postal_code')->nullable();
            $table->string('city')->nullable();
            $table->string('actual_job')->nullable();
            $table->string('interests')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('teachers', function (Blueprint $table) {
            $table->dropColumn('age');
            $table->dropColumn('postal_code');
            $table->dropColumn('city');
            $table->dropColumn('actual_job');
            $table->dropColumn('interests');
        });
    }
};
