<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class() extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('students', function (Blueprint $table) {
            // Remove the existing foreign key
            $table->dropForeign(['student_level_id']);

            // Remove the existing column
            $table->dropColumn('student_level_id');

            // Add the new foreign key column
            $table->foreignId('academic_level_class_id')->nullable()->constrained()->onDelete('cascade');

            // Update nullability for existing columns (optional)
            $table->string('gender')->nullable()->change();
            $table->text('learning_objective')->nullable()->change();

            // Add new "age" column of type integer
            $table->integer('age')->nullable();

            // Remove the existing "DOB" column
            $table->dropColumn('DOB');

            // Add new columns
            $table->string('postal_code')->nullable();
            $table->string('city')->nullable();
            $table->string('country')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('students', function (Blueprint $table) {
            // Drop the new foreign key column
            $table->dropForeign(['academic_level_class_id']);

            // Add back the "DOB" column if needed
            $table->date('DOB')->nullable();

            // Remove the new "age" column
            $table->dropColumn('age');
        });
    }
};
