<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class() extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('reprogrammed_lessons', function (Blueprint $table) {
            $table->dropColumn('status');
        });
        Schema::table('teachers', function (Blueprint $table) {
            $table->string('status')->default('active')->change();
        });
        Schema::table('courses', function (Blueprint $table) {
            $table->string('status')->default('active')->change();
        });
        Schema::table('teachers', function (Blueprint $table) {
            $table->string('availability')->default('available')->change();
        });
        Schema::table('lessons', function (Blueprint $table) {
            $table->string('status')->default('pending')->change();
        });
        DB::statement('ALTER TABLE lessons DROP CONSTRAINT lessons_status_check;');
        DB::statement("ALTER TABLE lessons ADD CONSTRAINT lessons_status_check CHECK (status IN ('scheduled','completed', 'canceled', 'expired','in_progress', 'pending', 'pending_schedule'))");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
    }
};
