<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class() extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('teachers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('first_name');
            $table->string('last_name')->nullable();
            $table->string('email')->unique();
            $table->string('phone_number')->nullable();
            $table->text('biography')->nullable();
            $table->text('education')->nullable();
            $table->integer('experience')->nullable();
            $table->string('gender')->nullable();
            $table->string('address')->nullable();
            $table->string('profile_image')->nullable();
            $table->string('country')->nullable();
            $table->string('language')->nullable();
            $table->string('status')->default('actif');
            $table->string('availability')->default('disponible');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('teachers');
    }
};
