<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Google_Client;
use Google\Service\Drive as GoogleServiceDrive;

class GoogleDriveServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        $this->app->singleton(Google_Client::class, function ($app) {
            $client = new Google_Client();
            $client->setAuthConfig(base_path('app/google-drive/google-service-account.json'));
            $client->addScope(GoogleServiceDrive::DRIVE);
            $client->setAccessType('offline');
            $client->setApprovalPrompt('force');
            
            return $client;
        });

        $this->app->singleton(GoogleServiceDrive::class, function ($app) {
            $client = $app->make(Google_Client::class);
            return new GoogleServiceDrive($client);
        });
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        //
    }
}