<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class WelcomeTeacherNotification extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public $password;

    public function __construct($password)
    {
        $this->password = $password;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @return MailMessage
     */
    public function toMail($notifiable)
    {
        $signInUrl = env('FRONTEND_URL').'/login';

        return (new MailMessage())
        ->subject('Welcome to AlloTutor!')
        ->line('Welcome to AlloTutor! Your account as a teacher has been successfully created on our platform. Please use the following credentials to sign in:')
        ->line('Email: '.$notifiable->email)
        ->line('Password: '.$this->password)
        ->line('Please sign in using the following link and update your password as soon as possible:')
        ->action('Sign In', $signInUrl)
        ->line('This is a sensitive message, and your password should be kept confidential.')
        ->salutation('Thank you for joining our Team!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
        ];
    }
}
