<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class ResetPasswordNotification extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * The password reset token.
     *
     * @var string
     */
    public $token;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($token)
    {
        $this->token = $token;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @return MailMessage
     */
    public function toMail($notifiable)
    {
        $frontendUrl = env('FRONTEND_URL');
        $resetUrl = $frontendUrl.'/reset_password?password_reset_token='.$this->token.'&email='.urlencode($notifiable->email);

        $expiration = config('auth.passwords.users.expire');

        $expirationUnit = 'minutes';

        if ($expiration >= 60) {
            $expiration = floor($expiration / 60);
            $expirationUnit = 'hours';
        }

        return (new MailMessage())
            ->line('Vous recevez cet e-mail car nous avons reçu une demande de réinitialisation de votre mot de passe pour votre compte.')
            ->action('Réinitialiser le mot de passe', $resetUrl)
            ->line("Ce lien de réinitialisation expirera dans {$expiration} {$expirationUnit}.")
            ->line("Si vous n'avez pas demandé de réinitialisation de mot de passe, aucune action supplémentaire n'est requise.");        
    }
}
