<?php

namespace App\Notifications;

use App\Models\Message;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class NewChatMessageNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public $message;
    public $senderDetails;
    public $recipientType;
    public $receiverId;
    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(Message $message, $senderDetails, string $recipientType, $receiverId)
    {
        $this->message = $message;
        $this->senderDetails = $senderDetails;
        $this->recipientType = $recipientType;
        $this->receiverId = $receiverId;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $baseUrl = env('FRONTEND_URL');
        $senderName = $this->senderDetails->first_name ?? 'AlloTutor';

        return (new MailMessage())
            ->subject('Vous avez 1 nouveau message')
            ->line("**{$senderName}** vous a envoyé un nouveau message.")
            ->line('Contenu du message : ' . $this->truncateMessage())
            ->action('Voir le message', url("{$baseUrl}/{$this->recipientType}/dashboard"));
    }

    /**
     * Truncate message for notifications.
     */
    private function truncateMessage()
    {
        return strlen($this->message->message) > 100 
            ? substr($this->message->message, 0, 100) . '...' 
            : $this->message->message;
    }
}
