<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class AccountRestoreNotification extends Notification implements ShouldQueue
{
    use Queueable;

    protected $restoreToken;
    protected $restoredByAdmin;

    /**
     * Create a new notification instance.
     *
     * @param string $restoreToken The restore token for the account.
     * @param bool $restoredByAdmin Whether the restoration was done by an admin.
     */
    public function __construct($restoreToken, $restoredByAdmin = false)
    {
        $this->restoreToken = $restoreToken;
        $this->restoredByAdmin = $restoredByAdmin;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $url = env('FRONTEND_URL') . '/login?user_reset_token=' . $this->restoreToken;

        $mailMessage = (new MailMessage)
            ->subject('Restauration de votre compte')
            ->greeting('Bonjour,');

        if ($this->restoredByAdmin) {
            $mailMessage->line('Votre compte a été restauré par l\'équipe AlloTutor.')
                ->line('Vous pouvez maintenant vous reconnecter à votre compte');
        } else {
            $mailMessage->line('Nous avons reçu une demande de restauration de votre compte.')
                ->line('Si vous n\'êtes pas à l\'origine de cette demande, vous pouvez ignorer cet email.')
                ->action('Restaurer mon compte', $url)
                ->line('Ce lien expirera dans 24 heures.');
        }

        $mailMessage->line('Merci d\'utiliser notre application!');

        return $mailMessage;
    }

}