<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable
{
    use HasApiTokens;
    use HasFactory;
    use Notifiable;
    use HasRoles;
    use SoftDeletes;

    protected $hidden = [
        'password',
    ];

    public function teacher()
    {
        return $this->hasOne(Teacher::class);
    }

    public function student()
    {
        return $this->hasOne(Student::class);
    }

    public function lessons()
    {
        return $this->hasMany(Lesson::class);
    }

    public function paymentMethods(): HasMany
    {
        return $this->hasMany(PaymentMethod::class);
    }

    public function accountPauseHistories(): HasMany
    {
        return $this->hasMany(AccountPauseHistory::class);
    }

    public function notificationPref()
    {
        return $this->hasOne(NotificationPreference::class);
    }

    public function reports()
    {
        return $this->hasMany(Report::class, 'reporter_id');
    }

    public function notifications()
    {
        return $this->morphMany(Notification::class, 'notifiable');
    }

    public function files()
    {
        return $this->hasMany(File::class, 'created_by');
    }

    protected static function booted()
    {
        static::created(function ($user) {
            $user->notificationPref()->create([
                'new_lessons' => true,
                'lesson_updates' => true,
                'new_messages' => true,
                'events_promotions' => true,
                'app_updates' => true,
                'lesson_reminders' => true,
                'reminder_time' => '60',
                'email_notifications' => true,
                'in_app_notifications' => true, 
            ]);
        });
    }
}
