<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Teacher extends Model
{
    use HasFactory;

    public function casts(): array
    {
        return [
            'balance' => 'double'
        ];
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function courses()
    {
        return $this->belongsToMany(Course::class, 'teacher_courses');
    }

    public function lessons()
    {
        return $this->hasMany(Lesson::class);
    }

    public function availabilities()
    {
        return $this->hasMany(TeacherAvailability::class);
    }

    public function payments(): HasMany
    {
        return $this->hasMany(TeacherPayment::class);
    }
}
