<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Course extends Model
{
    use HasFactory;

    public function teachers()
    {
        return $this->belongsToMany(Teacher::class, 'teacher_courses');
    }

    public function students()
    {
        return $this->belongsToMany(Student::class, 'student_courses');
    }

    public function courseCategory()
    {
        return $this->belongsTo(CourseCategory::class);
    }

    public function lessons()
    {
        return $this->hasMany(Lesson::class);
    }

    public function folder()
    {
        return $this->hasOne(File::class, 'course_id', 'id')->where('is_folder', true);
    }
}
