<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class EmailUpdateConfirmation extends Mailable
{
    use Queueable, SerializesModels;

    public $confirmationCode;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($confirmationCode)
    {
        $this->confirmationCode = $confirmationCode;
    }

      /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('Confirmez la mise à jour de votre adresse e-mail')
                    ->view('emails.email_update_confirmation')
                    ->with([
                        'confirmationCode' => $this->confirmationCode,
                    ]);
    }
}
