<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\Lesson;

class LessonAccess
{
    public function handle(Request $request, Closure $next)
    {
        $user = $request->user();
        $lesson = $request->route('lesson');

        // If user is admin, allow access
        if ($user->hasRole('admin')) {
            return $next($request);
        }

        // Check if lesson exists
        if (!$lesson instanceof Lesson) {
            return response()->json(['message' => 'Lesson not found'], 404);
        }

        $isStudent = $user->student && $lesson->student_id === $user->student->id;
        $isTeacher = $user->teacher && $lesson->teacher_id === $user->teacher->id;

        if ($isStudent || $isTeacher) {
            return $next($request);
        }

        return response()->json(['message' => 'Unauthorized access'], 403);
    }
}