<?php

namespace App\Http\Middleware;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CheckStudentAuthorization
{
    /**
     * Handle an incoming request.
     *
     * @param \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse) $next
     *
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, \Closure $next)
    {
        $user = Auth::user();
        $routeStudentId = $request->route('student')->user_id;

        if ($request->isMethod('put')) {
            // For GET requests, allow access only if the user ID matches the route's student ID
            if ($user->id !== $routeStudentId) {
                return response()->json(['message' => 'Unauthorized'], 403);
            }
        } else {
            // For other requests (PUT, POST, DELETE, etc.), allow access for admins or matching user ID
            if (!$user->hasRole('admin') && $user->id !== $routeStudentId) {
                return response()->json(['message' => 'Unauthorized'], 403);
            }
        }

        return $next($request); // Allow access if conditions are met
    }
}
