<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Notification;
use Symfony\Component\Uid\Uuid;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Log;

class NotificationController extends Controller
{
    public function index(User $user)
    {
        $notifications = $user->notifications()->orderBy('created_at', 'desc')->get();
        $user->notifications()->update(['seen' => true]);

        return response()->json([
            'notifications' => $notifications,
        ]);
    }

    public function show(User $user, Notification $notification)
    {
        $notification = $user->notifications()->findOrFail($notification->id);

        return response()->json([
            'nptification' => $notification,
        ]);
    }

    public function markAsRead(User $user, Notification $notification)
    {
        try {
            if (!$notification) {
                return response()->json([
                    'message' => 'Notification not found',
                ], 404);
            }

            $notification->read_at = now();
            $notification->save();

            return response()->json([
                'message' => 'Notification marked as read',
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'message' => 'An error occurred while marking the notification as read',
                'error' => $e->getMessage(),
            ], 400);
        }
    }

    public function markAllAsRead(User $user)
    {
        $user->unreadNotifications()->update(['read_at' => now()]);

        return response()->json([
            'message' => 'All notifications marked as read',
        ]);
    }

    public function markAsSeen(User $user, Notification $notification)
    {

        if (!$notification) {
            return response()->json([
                'message' => 'Notification not found',
            ], 404);
        }
        $notification->seen = true;
        $notification->save();

        return response()->json([
            'message' => 'Notification marked as seen',
        ]);
    }

    public function markAllAsSeen(User $user)
    {
        $user->notifications()->update(['seen' => true]);

        return response()->json([
            'message' => 'All notifications marked as seen',
        ]);
    }

    public function destroy(User $user, Notification $notification)
    {
        $notification = $user->notifications()->findOrFail($notification->id);
        $notification->delete();

        return response()->json([
            'message' => 'Notification deleted',
        ]);
    }

    public function getUnseenCount(User $user)
    {
        $count = $user->notifications()->where('seen', false)->count();

        return response()->json([
            'unseen_count' => $count,
        ]);
    }
}
