<?php

namespace App\Http\Controllers;

use App\Models\Faq;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;


class FaqController extends Controller
{
    // Display a listing of the FAQs
    public function index()
    {
        $faqs = Faq::all();
        return response()->json([
            'faqs' => $faqs
        ]);
    }

    // Display the specified FAQ
    public function show(Faq $faq)
    {
        return response()->json([
            'faq' => $faq
        ]);
    }

    // Store a newly created FAQ
    public function store(Request $request)
    {
        try {
            $validatedData = $request->validate([
                'question' => 'required|string|max:255',
                'answer' => 'required|string',
                'role' => 'required|in:all,teachers,students',
            ]);

            $faq = Faq::create($validatedData);

            return response()->json([
                'message' => 'FAQ created successfully',
                'message_code' => 'FAQ_CREATE_SUCCESS',
                'faq' => $faq
            ], 201);
        } catch (\Exception $e) {
            return response()->json([
                'message' => 'Failed to create FAQ',
                'message_code' => 'FAQ_CREATE_ERROR',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    // Update the specified FAQ
    public function update(Request $request, Faq $faq)
    {
        try {
            $validatedData = $request->validate([
                'question' => 'required|string|max:255',
                'answer' => 'required|string',
                'role' => 'required|in:all,teachers,students',
            ]);

            $faq->update($validatedData);

            return response()->json([
                'message' => 'FAQ updated successfully',
                'message_code' => 'FAQ_UPDATE_SUCCESS',
                'faq' => $faq
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'message' => 'Failed to update FAQ',
                'message_code' => 'FAQ_UPDATE_ERROR',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    // Remove the specified FAQ
    public function destroy(Faq $faq)
    {
        try {
            $faq->delete();

            return response()->json([
                'message' => 'FAQ deleted successfully',
                'message_code' => 'FAQ_DELETE_SUCCESS'
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'message' => 'Failed to delete FAQ',
                'message_code' => 'FAQ_DELETE_ERROR',
                'error' => $e->getMessage()
            ], 500);
        }
    }


}