<?php

namespace App\Http\Controllers;

use App\Models\CourseCategory;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;

class CourseCategoryController extends Controller
{
    public function index()
    {
        $categories = CourseCategory::orderBy('updated_at', 'desc')->get();

        return response()->json(['categories' => $categories]);
    }

    public function show(CourseCategory $category)
    {
        return response()->json(['category' => $category]);
    }

    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'course_category_name' => 'required|string|unique:course_categories',
        ]);

        $category = CourseCategory::create($validatedData);

        return response()->json([
            'category' => $category,
            'message' => 'Course category created successfully!',
        ]);
    }

    public function update(Request $request, CourseCategory $category)
    {
        $validatedData = $request->validate([
            'course_category_name' => 'nullable|string|unique:course_categories,name,'.$category->id,
        ]);

        $category->update($validatedData);

        return response()->json([
            'category' => $category,
            'message' => 'Course category updated successfully!',
        ]);
    }

    public function destroy(CourseCategory $category)
    {
        $category->delete();

        return response()->json([
            'message' => 'Course category deleted successfully!',
        ]);
    }
}
