<?php

namespace App\Http\Controllers;

use App\Models\AcademicLevel;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;

class AcademiclevelController extends Controller
{
    public function index()
    {
        $levels = AcademicLevel::with(['classes'])->orderBy('updated_at', 'desc')->get();

        return response()->json(['academic_levels' => $levels]);
    }

    public function show(AcademicLevel $level)
    {
        return response()->json(['Academic_level' => $level]);
    }

    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'level_title' => 'required|string|unique:academic_levels',
        ]);

        $level = AcademicLevel::create($validatedData);

        return response()->json([
            'Academic_level' => $level,
            'message' => 'Academic level created successfully!',
        ]);
    }

    public function update(Request $request, AcademicLevel $level)
    {
        $validatedData = $request->validate([
            'level_title' => 'nullable|string|unique:academic_levels,level_title,'.$level->id,
        ]);

        $level->update($validatedData);

        return response()->json([
            'Academic_level' => $level,
            'message' => 'Academic level updated successfully!',
        ]);
    }

    public function destroy(AcademicLevel $level)
    {
        $level->delete();

        return response()->json([
            'message' => 'Academic level deleted successfully!',
        ]);
    }
}
