<?php

namespace App\Events;

use App\Models\User;
use Illuminate\Broadcasting\Channel;
use Illuminate\Queue\SerializesModels;
use App\Http\Controllers\StudentController;
use Illuminate\Foundation\Events\Dispatchable;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;

class UpdateCredit implements ShouldBroadcast
{
    use Dispatchable;
    use InteractsWithSockets;
    use SerializesModels;

    /**
     * Create a new event instance.
     *
     * @return void
     */
    public $userId;
    public $credits;

    public function __construct($userId)
    {
        $this->userId = $userId;
        $this->credits = $this->getRemainingCredits($userId);
    }

    /**
     * Get the channels the event should broadcast on.
     *
     * @return \Illuminate\Broadcasting\Channel|array
     */
    public function broadcastOn()
    {
        return new Channel('student-channel.'.$this->userId);
    }

    /**
     * Get the remaining credits for the user.
     *
     * @param int $userId
     * @return int
     */
    private function getRemainingCredits($userId)
    {
        $studentController = new StudentController();
        $user = User::find($userId);

        if (!$user || !$user->student) {
            return 0; // Return 0 if the user or student record does not exist
        }

        return $studentController->getCredits($user->student);
    }
}
