<?php

namespace App\Console\Commands;

use App\Models\File;
use App\Models\User;
use App\Models\Course;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use App\Services\GoogleDriveService;

class createFoldersForCourses extends Command
{

    protected $driveService;

    public function __construct(GoogleDriveService $driveService)
    {
        parent::__construct();
        $this->driveService = $driveService;
    }
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'create:folders_for_courses';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create folders for courses in Google Drive';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
         // Retrieve all courses from the database
        $courses = Course::all();

        $createdFolders = [];

        foreach ($courses as $course) {
            try {
                // Create a folder for the course using its name
                $folderId = $this->driveService->createFolder($course->course_title, 'root');

                // Save the folder details in the files table
                $adminUser = User::whereHas('roles', function ($query) {
                    $query->where('name', 'admin');
                })->first();

                File::create([
                    'file_drive_id' => $folderId,
                    'created_by' => $adminUser->id,
                    'is_folder' => true,
                    'course_id' => $course->id,
                ]);

                $createdFolders[] = [
                    'course_id' => $course->id,
                    'course_name' => $course->name,
                    'folder_id' => $folderId,
                ];
            } catch (\Exception $e) {
                Log::error('Failed to create folder for course', [
                    'course_id' => $course->id,
                    'course_name' => $course->name,
                    'error' => $e->getMessage(),
                ]);
            }
        }

        $this->info('Folders created for all courses successfully.');
    }
}
