<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;

class UpdateAdminEmail extends Command
{
    protected $signature = 'update:admin-email';
    protected $description = 'Update the email of all users with role admin to contact@allotutor.org';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $adminUsers = User::whereHas('roles', function($query) {
            $query->where('name', 'admin');
        })->get();

        foreach ($adminUsers as $user) {
            $user->email = 'contact@allotutor.org';
            $user->save();
        }

        $this->info('Admin emails have been updated successfully.');
    }
}