<?php

namespace App\Console\Commands;

use App\Models\Meeting;
use Carbon\Carbon;
use Illuminate\Console\Command;

class EndOverdueMeetings extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'meetings:end-overdue';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'End meetings that have been running for more than 1 hour and 45 minutes';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $cutoffTime = Carbon::now()->subHours(1)->subMinutes(45);

        $overdueMeetings = Meeting::where('created_at', '<=', $cutoffTime)
            ->whereHas('lesson', function ($query) {
                $query->whereIn('status', ['in_progress', 'paused']);
            })
            ->get();

        foreach ($overdueMeetings as $meeting) {
            $this->info("Ending meeting {$meeting->id} created at {$meeting->created_at}");
            app(\App\Http\Controllers\MeetingController::class)->endMeeting($meeting);
        }

        $this->info('Overdue meeting check completed.');
    }
}
