<?php

namespace App\Console\Commands;

use App\Models\User;
use Illuminate\Console\Command;
use App\Models\NotificationPreference;

class CreateDefaultNotificationPreferences extends Command
{
    protected $signature = 'preferences:create-defaults';
    protected $description = 'Create default notification preferences for all users';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        $users = User::all();

        foreach ($users as $user) {
            NotificationPreference::firstOrCreate(
                ['user_id' => $user->id],
                [
                    'new_lessons' => true,
                    'lesson_updates' => true,
                    'new_messages' => true,
                    'events_promotions' => true,
                    'app_updates' => true,
                    'lesson_reminders' => true,
                    'reminder_time' => '60',
                    'email_notifications' => true,
                    'in_app_notifications' => true,
                ]
            );
        }

        $this->info('Default notification preferences have been set for all users.');
    }
}
